implementation module deltaIOSystem;

//	DeviceDefinitions:

import	timerDef, menuDef, windowDef, dialogDef;

::	IOSystem	 *s *io	:==	[DeviceSystem s io];
::	DeviceSystem *s *io	=	TimerSystem		[TimerDef	s io]
						|	MenuSystem		[MenuDef 	s io]
						|	WindowSystem	[WindowDef	s io]
						|	DialogSystem	[DialogDef	s io]
						|	AppleEventSystem (AppleEventSystemState s io);

// RWS ::	AppleEventSystemState *s *io :== String -> s -> *(io -> (s,io));
::	AppleEventSystemState *s *io :== AppleEventHandler s io;

::	AppleEventHandler *s *io =
		{
			openHandler :: (String -> s -> *(io -> *(s,io))),
			quitHandler :: (s -> *(io -> *(s,io))),
			scriptHandler :: (String -> s -> *(io -> *(s,io))),
			clipboardChangedHandler :: (s -> *(io -> *(s,io)))
		};
